/*-----------------------------------------------------------------------*/
/* Copyright 2012 to current year.                                       */
/* AVEVA Solutions Limited and its subsidiaries. All rights reserved.    */
/*-----------------------------------------------------------------------*/
/* eslint-disable */
(function (angular) {
  'use strict';

  //! Register the HTML needed to provide a viewer for MIME type application/x-lfm
  angular.module('aveva.dashboard.custom').config([
    'FileViewerConfigProvider',
    function (FileViewerConfigProvider) {
      var viewerHTML =
        '<div id="lfm-netview-div" data-lfm-netview="" data-full-id="fullId" data-file="file" data-netview-viewer="" data-file-url="file" data-item-selected-handler="selection" data-items-to-select="selectedTerms"></div>';
      FileViewerConfigProvider.register('application/x-lfm', viewerHTML);
    }
  ]);

  //! Define the lfmNetview directive
  angular.module('aveva.dashboard.custom').directive('lfmNetview', [
    '$window',
    '$log',
    'OpenItems',
    'ContentItemDataService',
    'Notify',
    'NetViewWrapper',
    'NetViewListener',
    'NetViewWrapperCommands',
    'NetViewListenerCommands',
    'NetViewNotificationService',
    function (
      $window,
      $log,
      OpenItems,
      ContentItemDataService,
      Notify,
      NetViewWrapper,
      NetViewListener,
      NetViewWrapperCommands,
      NetViewListenerCommands,
      NetViewNotifyService
    ) {
      var registerResizeHandler = function (scope, element) {
        // Setup code for catching resizes
        scope.getElementDimensions = function () {
          return { h: element.height(), w: element.width() };
        };
        scope.$watch(
          scope.getElementDimensions,
          function (newValue) {
            element
              .find('#size_div')
              .html('Size is ' + newValue.w + 'x' + newValue.h);
          },
          true
        );
        element.bind('resize', function () {
          scope.$apply();
        });
      };

      return {
        restrict: 'A',
        scope: {
          file: '=file',
          fileId: '=fileId',
          itemSelectedHandler: '=itemSelectedHandler',
          itemsToSelect: '=itemsToSelect'
        },

        template:
          "<iframe id='netviewframe' src='about:blank' style='width:100%; height:100%;'/>",

        link: function (scope, element) {
          var netview = element[0].firstChild;
          var baseUrl = location.protocol + '//' + location.host;
          var netViewUrl = baseUrl + '/LFM NetView/index.html';
          var project = null;

          if (scope.file) {
            project = scope.file.split('@')[1];
          }

          netview.src = netViewUrl + '?project=' + project;

          //get new objects
          var netviewListener = NetViewListener();
          var netviewWrapper = NetViewWrapper();

          //this is a nasty way of doing this, however until the next release of Dashboard it is currently the only way of suspending notification dialog boxes
          var notifyFnc = Notify.error;
          scope.aNetSuspendNotifications = function () {
            Notify.error = function () {};
          };
          scope.aNetResumeNotifications = function () {
            Notify.error = notifyFnc;
          };

          netviewListener.setupEventCallback($window);
          netviewListener.setNetviewListenerCommands(NetViewListenerCommands);
          netviewWrapper.setNetViewWrapperCommands(NetViewWrapperCommands);
          scope.currentTab = OpenItems.getCurrent();

          var netviewNotify = NetViewNotifyService(
            scope,
            netviewListener,
            netviewWrapper,
            ContentItemDataService
          );

          netviewListener.subscribeForEvent('netview-initialised', function (
            data
          ) {
            netviewWrapper.setNetViewWindow(netview);
            netviewWrapper.informNetView();
            netviewNotify.setNetViewReady();
            //In cloud mode we just add the project to the querystring. The client will then log in automatically as normal
            if (data.buildType === 'Local') {
              netviewWrapper.openProjectWithSSO(project);
            }
          });
          registerResizeHandler(scope, element);
        }
      };
    }
  ]);
})(angular);

(function (window) {
  window.notify = function (notification, item) {};
})(window);
